*******************************************************************************
*                          680xx Grundprogramm uhr                            *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                             Uhren-Routinen                                  *
*******************************************************************************


uhrinit:
 bsr uhr2init                   * RTC Uhr
 cmp.b #3, uhrausw(a5)
 bne.s uhrinit1                 * nchste Uhr
 bset.b #2, keydil(a5)          * soll ja auch ohne DIL-Key laufen :-P
 bra.s uhrinitx
uhrinit1:                       * Ab hier "normal" weiter
 move.b keydil(a5),d0           * DIL-Schalter holen
 lsr.b #2,d0                    * Bit 2 nach Bit 0
 and.b #1,d0                    * Nur Bit 0 briglassen
 move.b d0,uhrausw(a5)          * Bestimmung, ob Uhrenbaugruppe vorhanden ist
 beq.s uhrinitx                 * keine Uhr
 bsr swinit                     * sonst Smart-Watch oder Uhr(E050)
uhrinitx:
 rts

swinit:                         * Smart-Watch Identifizierung/Initialisierung
 suba.l a0,a0                   * Von Null an suchen
 clr uhradr(a5)                 * Adressenmerker
 move.l #$5ca33ac5,d0           * Wert fr Uhrerkennung
 moveq #128-1,d1                * Adressbereich, der durchsucht werden mu
swinit1:
 bsr ramchk                     * Smart-Watch mu unter Ram liegen
 bcs.s swinit4                  * Kein Ram, dann weiter
 move.b (a0),d2                 * Wert merken, damit kein Ram zerstrt wird
 moveq #64-1,d3                 * 64 Bit-Muster
swinit2:
 move.b d0,(a0)                 * Bit bertragen
 ror.l #1,d0                    * Nchstes Bit
dbra d3,swinit2
 moveq #8*8-1,d3
swinit3:
 cmp.b #$8a,(a0)                * Wenn einmal nicht $8a, dann Uhr vorhanden
 bne.s swinit6                  * Sonst Uhr nicht vorhanden
dbra d3,swinit3
 move.b d2,(a0)                 * Ram zurck
swinit4:
 adda.l #8*1024*cpu,a0          * 8*cpu Kbyte weiter
 addq #cpu,uhradr(a5)           * Uhradresse zeigt im Abstand von 8*cpu Kbyte an
dbra d1,swinit1                 * Schleife
rts
swinit5:
 tst.b (a0)                     * Nur abfragen, damit Smart-Watch ausgeschaltet
swinit6:                        * wird
dbra d3,swinit5
 move.b d2,(a0)                 * Reparieren
 move.b #2,uhrausw(a5)          * Merker fr Smart-Watch
rts

uhr2init:
 clr.b uhrausw(a5)              * noch keine Uhr
 move.b #$0b, rtcreg.w
 move.b #$03, rtcdat.w          * BCD und Co
 bsr uwait                      * ein bisschen warten
 move.b #$7f, rtcreg.w          * RAM Adr. $7F zum testen
 move.b rtcdat.w, d0            * Inhalt sichern
 bsr uwait
 move.b #$7f, rtcreg.w
 move.b #$a5, rtcdat.w          * $A5 erster Testwert
 bsr uwait
 move.b #$7f, rtcreg.w
 cmp.b #$a5, rtcdat             * Stimmt es?
 bne.s u2i01                    * nein -> keine Uhr
 bsr uwait
 move.b #$7f, rtcreg.w
 move.b #$3c, rtcdat.w          * $3C zweiter Testwert
 bsr uwait
 move.b #$7f, rtcreg.w
 cmp.b #$3c, rtcdat.w           * stimmts noch?
 bne.s u2i01                    * nein
 bsr uwait
 move.b #$7f, rtcreg.w
 move.b d0, rtcdat              * Inhalt zurck
 move.b #3, uhrausw(a5)         * die Uhr luft
u2i01:
rts

***  Uhr E050 Bereich  ***

getuhr:                         * Uhrzeit lesen
 cmp.b #1,uhrausw(a5)           * Baugruppe eingestellt ?
 bhi getuhr1                    * Baugruppe nicht vorhanden, dann weiter
 movem.l d0-d4,-(a7)
 moveq #4-1,d1                  * Viermal 1 (0 invers) ausgeben
getuhra:
 clr d0
 bsr.s pulswr                   * Bit ausgeben
dbra d1,getuhra
 moveq #7-1,d1                  * Dann Daten lesen
getuhrb:
 moveq #8-1,d2                  * Datenbits
 clr d3                         * Ergebnis
getuhrc:
 move.b #4,uhr.w                * CS setzen
 bsr.s uwait
 move.b #6,uhr.w
 bsr.s uwait
 move.b uhr.w,d0                * Ein Bit einlesen
 and.b #1,d0                    * Nur ein Bit
 or.b d0,d3
 ror.b #1,d3                    * Einzelbits einlesen
dbra d2,getuhrc
 move.b d3,(a0)+                * Byte ablegen
dbra d1,getuhrb
 clr.b (a0)+                    * Null, damit kompatibel zur Smart-Watch
 clr.b uhr.w                    * CS ausschalten
 movem.l (a7)+,d0-d4
rts

pulswr:
 addq #4,d0
 move.b d0,uhr.w                * CS setzen
 addq #2,d0
 bsr.s uwait
 move.b d0,uhr.w                * Wert ausgeben

uwait:
 moveq #5*cpu,d4                * Ein bichen warten, da Baugruppe nicht so
uwait0:                         * schnell (Zeit ist CPU-abhngig)
 dbra d4,uwait0
rts

setuhr:                         * Uhrzeit setzen
 cmp.b #1,uhrausw(a5)           * Baugruppe ?
 bhi setuhr1                    * Keine Uhrenbaugruppe, dann weiter
 movem.l d0-d4,-(a7)
 moveq #3-1,d1                  * Start Info
setuhra:
 clr d0
 bsr.s pulswr                   * 0 0 0 ausgeben
dbra d1,setuhra
 moveq #1,d0                    * 1 danach als
 bsr.s pulswr                   * Kennung
 moveq #7-1,d1                  * Anzahl Bytes
setuhrb:
 moveq #8-1,d2                  * Anzahl Bits
 move.b (a0)+,d3                * Data holen
 not.b d3                       * Invers ausgeben
setuhrc:
 rol.b #1,d3                    * Einzelbits ausgeben
 move.b d3,d0
 and.b #1,d0                    * Nur ein Bit
 bsr.s pulswr                   * ausgeben
dbra d2,setuhrc                 * Alle Bits
dbra d1,setuhrb                 * Alle Bytes
 clr.b uhr.w                    * CS neutral stellen
 addq.l #1,a0                   * Hinter letzten Wert
 movem.l (a7)+,d0-d4
rts

*** Smart-Watch Bereich ***

getuhr1:
 cmp.b #2,uhrausw(a5)           * Smart-Watch ?
 bhi getuhr2                    * Keine Smart-Watch, dann weiter
 movem.l d0-d5/a1,-(a7)
 bsr.s uhr1ein                  * Smart-Watch einschalten
getuhr1a:
 clr d4
 moveq #8-1,d1                  * Anzahl Bits
getuhr1b:
 moveq #8-1,d2                  * Anzahl Bytes
 clr d0
getuhr1c:
 move.b (a1),d3                 * Bit holen
 and.b #1,d3                    * Nur ein Bit
 or.b d3,d0
 ror.b #1,d0                    * Bit rotieren
dbra d2,getuhr1c                * Ein Bit gelesen
 move.b uhrtab(pc,d1),d4        * Umkodieren, damit kompatibel zur Baugruppe
 move.b d0,0(a0,d4)             * Byte ablegen
dbra d1,getuhr1b
 move.b d5,(a1)                 * Byte im Ram reparieren
 addq.l #8,a0                   * Hinter letzten Wert setzen
 movem.l (a7)+,d0-d5/a1
rts

uhr1ein:                        * Smart-Watch einschalten
 moveq #0,d0
 move uhradr(a5),d0             * Adresse der Smart-Watch holen
 moveq #13,d1
 lsl.l d1,d0                    * Im 8 Kbyte Abstand
 movea.l d0,a1                  * Adresse der Uhr berechnet
 move.b (a1),d5                 * Wert merken, damit kein Ram zerstrt wird
 move.l #$5ca33ac5,d0           * Wert fr Erkennung
 moveq #64-1,d1                 * 64 Bit-Muster
uhr1eina:
 move.b d0,(a1)                 * Bit bertragen
 ror.l #1,d0                    * Nchstes Bit
dbra d1,uhr1eina
rts                             * OK, Uhr eingeschaltet

uhrtab:
 dc.b 4,3,2,5,0,1,6,7           * Umkodiertabelle fr Kompatibelitt

setuhr1:
 cmp.b #2,uhrausw(a5)           * Smart-Watch ?
 bhi setuhr2                    * Keine Smart-Watch, dann weiter
 movem.l d0-d5/a1,-(a7)         * Smart-Watch setzen
 bsr.s uhr1ein                  * Uhr einschalten
 clr d4
 moveq #8-1,d2                  * Anzahl Bytes
setuhr1a:
 move.b uhrtab(pc,d2),d4        * Umkodieren (kompatibel zur Baugruppe)
 move.b 0(a0,d4),d1             * Byte holen
 moveq #8-1,d3                  * Anzahl Bits
setuhr1b:
 move.b d1,(a1)                 * Bit bertragen
 ror.b #1,d1                    * Nchstes Bit
dbra d3,setuhr1b
dbra d2,setuhr1a
 move.b d5,(a1)                 * Ram reparieren
 addq.l #8,a0                   * Hinter letzten Wert
 movem.l (a7)+,d0-d5/a1
rts

*** neue Uhr Bereich ***

getuhr2:                        * neue Uhr
 cmp.b #3, uhrausw(a5)          * RTC?
 bne.s getuhrxx                 * keine Uhr
 movem.l d3/a1, -(a7)
getuhr2b:
 bsr uwait
 move.b #$0a, rtcreg.w
 move.b rtcdat.w, d3            * RTC bereit?
 bmi.s getuhr2b                 * nein
 move #7-1, d3                  * 7 Byte
 lea uhr2tab(pc), a1
getuhr2a:
 move.b (a1)+, rtcreg.w         * Adresse
 move.b rtcdat.w, (a0)+         * Daten
 bsr uwait                      * etwas warten
 dbra d3, getuhr2a
 clr.b (a0)+                    * keine 1/100 Sekunden
 movem.l (a7)+, d3/a1
getuhrxx:
rts

setuhr2:                        * neue Uhr
 cmp.b #3, uhrausw(a5)          * RTC?
 bne.s setuhrxx                 * keine Uhr
 movem.l d3/a1, -(a7)
setuhr2b:
 bsr uwait
 move.b #$0a, rtcreg.w
 move.b rtcdat.w, d3            * RTC bereit?
 bmi.s setuhr2b                 * nein
 move #7-1, d3                  * 7 Byte
 lea uhr2tab(pc), a1
setuhr2a:
 move.b (a1)+, rtcreg.w         * Adresse
 move.b (a0)+, rtcdat.w         * Daten
 bsr uwait                      * etwas warten
 dbra d3, setuhr2a
 addq.l #1, a0                  * keine 1/100 Sekunden
 movem.l (a7)+, d3/a1
setuhrxx:
rts

uhr2tab:
 dc.b $04, $02, $07, $08, $09, $06, $00
 ds 0                                                                                                                                        te12a:
 cmpa.l a3,a2
 beq.s txte12b                  * Cursor schon ganz vorne, dann nicht bewegen
 moveq #1,d4
 bsr txteaus                    * Ein Zeichen ausgeben
 subq.l #1,a2                   * Cursor zurck
txte12b:
rts
txtein13:
 cmp.b #20,d0                   * Ctrl-T
 bne.s txtein14
 movea.l a2,a0                  * Cursoradresse
txte13a:
 move.b #' ',(a0)+              * Alle Zeichen hinter Cursor lschen
 cmpa.l a0,a4
 bne.s txte13a                  * Bis hinten
 moveq #-1,d4
b